package com.company.tp07_01_localtodoapp.viewmodel;

import android.app.Application;

import androidx.annotation.NonNull;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;

import com.company.tp07_01_localtodoapp.database.Todo;
import com.company.tp07_01_localtodoapp.repository.TodoRepo;

import java.util.List;

public class TodoViewModel extends AndroidViewModel {

    private TodoRepo todoRepo;
    private LiveData<List<Todo>> todoList;
    public TodoViewModel(@NonNull Application application) {
        super(application);
        todoRepo = TodoRepo.getInstance(application);
        todoList = todoRepo.getTodoList();
    }
    public LiveData<List<Todo>> getTodoList() {
        return todoList;
    }

    public void insert(Todo todo) {
        todoRepo.insert(todo);
    }
}
